@extends('layouts.app')
@section('content')
<div class="content-wrapper">
	<div class="content pt-3">
		<div class="container-fluid">
			<div class="card border-0 shadow-custom">
				<div class="card-header border-grey">
					<h3 class="card-title">
						{{ __('plan.title') }}
					</h3>
				</div>
				<form method="post" action="{{ route('plan.store') }}">
					{{ csrf_field() }}
					<div class="card-body">
						<div class="row">
							<div class="col-lg-6">
								<div class="form-group">
									<label for="name" class="required">{{ __('plan.name') }}</label>
									<input type="text" value="{{ old('name') }}"
										class="form-control @error('name') is-invalid @enderror" name="name" id="name">
									@error('name')
									<span class="d-block invalid-feedback">{{ $message }}</span>
									@enderror
								</div>
							</div>
							<div class="col-lg-6">
								<div class="form-group">
									<label for="amount" class="required">{{ __('plan.amount') }}</label>
									<input type="text" value="{{ old('amount') }}"
										class="form-control @error('amount') is-invalid @enderror" name="amount"
										id="amount" placeholder="0">
									@error('amount')
									<span class="d-block invalid-feedback">{{ $message }}</span>
									@enderror
								</div>
							</div>
							<div class="col-lg-12">
								<div class="form-group">
									<label for="duration" class="required">{{ __('plan.duration') }}</label>
									<input type="number" value="{{ old('duration') }}"
										class="form-control @error('duration') is-invalid @enderror" name="duration"
										id="duration" placeholder="{{ __('plan.membership_duration') }}">
									@error('duration')
									<span class="d-block invalid-feedback">{{ $message }}</span>
									@enderror
								</div>
							</div>
							<div class="col-lg-12">
								<div class="form-group">
									<label for="description">{{ __('plan.description') }}</label>
									<textarea rows="4" class="form-control" name="description"
										id="description">{{ old('description') }}</textarea>
								</div>
							</div>
							<div class="col-lg-12">
								<button type="submit" class="btn btn-primary mt-1">{{ __('plan.save_plan') }}</button>
							</div>
						</div>
					</div>
				</form>
			</div>
		</div>
	</div>
</div>
@endsection